/** $Header: /ruurq2/st2/include/RCS/util.h,v 1.8 1997/12/18 14:24:14 jaaps Exp $
********************************** - - ****************************************
* 						   
*         _/_/_/_/_/_/    _/_/_/    _/_/      _/_/       SRON Utrecht
*      _/_/_/_/  _/_/  _/_/_/_/_/  _/_/_/  _/_/_/    
*     _/_/_/        _/_/      _/_/  _/_/_/_/_/       _/     _/ _/_/_/_/ _/_/_/
*      _/_/_/_/_/  _/_/_/_/_/_/_/    _/_/_/         _/     _/ _/     _/_/
*           _/_/_/_/_/_/_/_/_/_/  _/_/_/_/_/  _/_/ _/  _/ _/ _/_/_/ _/      
*  _/_/  _/_/_/_/_/_/      _/_/_/_/_/  _/_/_/     _/_/ _/_/ _/     _/_/  
* _/_/_/_/_/_/  _/_/      _/_/_/_/      _/_/     _/     _/ _/       _/_/_/   
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* Use	      :	
*
* Parameters  :	
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* Dependencies:	
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* Description :	
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* $Log: util.h,v $
 * Revision 1.8  1997/12/18  14:24:14  jaaps
 * non essential, cosmetic adjustments (no reason found in source).
 *
* Revision 1.7  1997/11/12 14:40:08  jaaps
*    added prototype for frmt_rd and dateTime2mjd.
*
* Revision 1.6  1997/09/08 08:40:25  jaaps
*    added prototype for mjd2date.
*
* Revision 1.5  1997/07/04 11:34:55  jaaps
*    added prototype for frmt_rda, formats ra, dec na.
*
* Revision 1.4  1997/05/23 11:18:28  jaaps
* non essential, cosmetic adjustments (no reason found in source).
*
*
* Revision 1.3  1996/09/23 13:32:23  jaaps
*    util.h: added prototype for asla_djcl, convert mjd to UT date string.
*    	   added prototype for asla_smat, solve simultaneous equations.
*
 * Revision 1.2  1996/06/18  13:10:20  jaaps
 *    util.h: prototypes added (set_trafomatrix_imim, trafo_imim).
 *
 * Revision 1.1  1996/04/25  21:04:41  sax
 * Initial revision
 *
********************************** - - ****************************************/

#ifndef UTIL_H_INCLUDED

#define UTIL_H_INCLUDED

#include <stdlib.h>

#include "wfcglobals.h"

static char *UTIL_H_ID= "$Header: /ruurq2/st2/include/RCS/util.h,v 1.8 1997/12/18 14:24:14 jaaps Exp $";

#define SEEDRANF(seed)	srand48(seed)
#define RANF(arg)	drand48()

double  drand48(void);
void    srand48(long int seedval);
/*
** almost all floating point data is stored in 32bit float
** variables, using float functions (specially sqrt, as it's used a lot) offers
** some speed gain.
*/
#ifdef HAVE_FFUNCTIONS
#define FFABSF(arg)	fabsf(arg)
#define FFLOG(arg)	logf(arg)
#define FFSQRT(arg)	sqrtf(arg)
#define FFEXP(arg)	expf(arg)
#define FFPOW(arg1,arg2)	powf(arg1,arg2)
#else
#define FFABSF(arg)	fabs(arg)
#define FFLOG(arg)	log(arg)
#define FFSQRT(arg)	sqrt(arg)
#define FFEXP(arg)	exp(arg)
#define FFPOW(arg1,arg2)	pow(arg1,arg2)
#endif

void bin1D (float *, cardinal, cardinal, cardinal, double, double);
/*
** in util/distributions.c
*/
void  init_randfun (int seed);
float normal       (float mn, float sgm);
float poisson      (float x, float p2g);

double ymdhms2mjd (cardinal, cardinal, cardinal, cardinal, cardinal, double);

double asla_cldj (char *date, char *time);
double dateTime2mjd (char *date, char *time);
char  *asla_djcl (double mjd, char *date);
double strtomjd (char *, char **, char *);

int asla_smat (int *n, float *a, float *y, float *d, int *jf, int *iw);
char *u32tobits    (cardinal c, char *s);
char *frmt_rda (double, double, double, char *);
char *frmt_rd  (double, double, char *);
char *mjd2date (double m, char *s, char *tz);

double  exo_alum (float *energy);
double  uau 	 (float *energy);
double  uber	 (float *energy);
double  ucarb 	 (float *energy);
double	uco2	 (float *energy);
double	uepoxy 	 (float *energy);
double	ufe	 (float *energy);
double	uhel	 (float *energy);
double	ukapton	 (float *energy);
double	uoxyg	 (float *energy);
double	uststeel (float *energy);
double	uxe	 (float *energy);
double	xabs	 (int *nz, float *energy);


int set_trafomatrix_ceim  (double *ra, double *de, double *na);
int set_trafomatrix_imce  (double *ra, double *de, double *na);
int trafo_ceim (double *ra, double *de, float *xo, float *yo, float nifov);
int trafo_imce (float *xi, float *yi, double *xo, double *yo);
int set_trafomatrix_imim(double *ra1, double *de1, double *na1,
			 double *ra2, double *de2, double *na2);
int trafo_imim(float *xi, float *yi, float *xo, float *yo);
void jz_shiftPointing (rpair, float, double *, double *, double *);
/*%
   added prototype for jz_shiftPointing.
%*/
#endif /* UTIL_H_INCLUDED */
