/** $Header: iros.c,v 1.37 99/02/01 17:45:26 jaaps Exp $
********************************** - - ****************************************
* 						   
*         _/_/_/_/_/_/    _/_/_/    _/_/      _/_/       SRON Utrecht
*      _/_/_/_/  _/_/  _/_/_/_/_/  _/_/_/  _/_/_/    
*     _/_/_/        _/_/      _/_/  _/_/_/_/_/       _/     _/ _/_/_/_/ _/_/_/
*      _/_/_/_/_/  _/_/_/_/_/_/_/    _/_/_/         _/     _/ _/     _/_/
*           _/_/_/_/_/_/_/_/_/_/  _/_/_/_/_/  _/_/ _/  _/ _/ _/_/_/ _/      
*  _/_/  _/_/_/_/_/_/      _/_/_/_/_/  _/_/_/     _/_/ _/_/ _/     _/_/  
* _/_/_/_/_/_/  _/_/      _/_/_/_/      _/_/     _/     _/ _/       _/_/_/   
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* Use	      :	cimage
*
* Parameters  :	
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* Dependencies:	
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* Description :	create sky image from eventlist	
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* $Log:	iros.c,v $
 * Revision 1.37  99/02/01  17:45:26  17:45:26  jaaps (Jaap Schuurmans)
 * non essential, cosmetic adjustments (no reason found in source).
 * 
* Revision 1.36  1998/06/18 07:42:10  jaaps
* non essential, cosmetic adjustments (no reason found in source).
*
* Revision 1.35  1998/05/26 08:24:53  jaaps
* no entry
*
* Revision 1.34  1998/05/26 08:24:00  jaaps
* no entry
*
* Revision 1.33  1998/05/13 10:28:34  jaaps
*    iros_forcepntng: extended, optionally apply sat-cam misalignment correction.
*
* Revision 1.32  1997/12/03 08:48:24  jaaps
*    added option to apply 2ndorder non-linearitiy corrections.
*
* Revision 1.31  1997/11/12 14:39:10  jaaps
*    iros: accept a .res, iros output, as input.
*          use the rdi extension as the detector image, the sourcelist
* 	 as an initial list of sources.
*    src_readcatalog parameter list adapted, firts arg. now existing cataloglist or NULL.
*
* Revision 1.30  1997/09/23 14:45:05  jaaps
* non essential, cosmetic adjustments (no reason found in source).
*
* Revision 1.29  1997/09/11 10:28:19  jaaps
*    iros.c: null pointer dereference protect added on ins->sim.det.
*
* Revision 1.28  1997/09/08 08:24:56  jaaps
*    added parameter, "PSFRSLTN" (-q), integral value i, set psf oversampling
*    		    (relative to detector pixel-size)  to 2i+1,.
*
* Revision 1.27  1997/07/04 12:14:27  jaaps
*   iros_introduction: oop
*
 * Revision 1.26  1997/07/04  11:34:36  jaaps
 *    new parameter SELPLANE (-u) to select a single plane from the
 *    input detector image for processing.
 *
* Revision 1.25  1997/07/01 10:21:29  jaaps
*    added parameter SKYRSLTN (-j), minimum distance in pixels to resolve in 2 separate sources.
*    hard code default was 1 pixel, default value now is 3.
*
* Revision 1.24  1997/06/26 15:14:27  jaaps
*    move code to parse XYSILST parameter in separate function, report parse errors.
*    added global gbl_revision, set to current DISTRIBUTION-PACKET revision,
*    appears on listfileheader and in any outputfiles, keyword REVISION.
*
* Revision 1.22  1997/06/20 13:57:07  jaaps
*    iros: effectuate ofits parameter, force FITS output when input is tspz image.
*          in the case of tspz format output,
* 	  - dump the sourcelist in ASCII to stdout.
* 	  - forget about the reduced detector image.
* 	 this was not yet implemented and dangled a bit.
* 	 new parameter, chnlset (option -e), put channel range data on
* 	 TSPZ format detectorimage, the imageheader does not have this information.
* 	 before always set to 1-31, greatly determines the psf.
*
* Revision 1.21  1997/06/18 14:05:47  jaaps
*    new parameter, XYSILST - list of x,y,si  position and spectral index of sources to subtract.
*    iros: do NOT yet by default use the voigt shape detector resolution.
*
* Revision 1.20  1997/05/30 11:55:55  jaaps
* oops
*
* Revision 1.19  1997/05/28 14:41:24  jaaps
* non essential, cosmetic adjustments (no reason found in source).
*
* Revision 1.18  1997/05/27 08:17:23  jaaps
*    iros: typo fixed in iros_creaters call.
* 	 inconsistent use of islfile field could leave it with an uninitialised
* 	 (non-zero) value, crashing wft_writehdu on a digital-alpha.
*
* Revision 1.17  1997/05/23 10:24:10  jaaps
*    iros: initial list of "sure" sources could be empty or none in FOV!!.
*    	 catch the resulting null pointers!!!.
*
* Revision 1.16  1997/04/28 08:49:16  jaaps
*    iros: new parameter POINTING, override pointing (ra,dec,na) from the
*    	 detecor image (.exp) inputfile.
*
* Revision 1.15  1997/04/23 11:28:02  jaaps
* non essential, cosmetic adjustments (no reason found in source).
*
* Revision 1.14  1997/04/16 10:01:29  jaaps
*   KeyRecord par_key: new parameter properties added, inputfile, outputfile etc.
*
* Revision 1.13  1997/04/11 15:21:41  jaaps
* non essential, cosmetic adjustments (no reason found in source).
*
* Revision 1.12  1997/02/27 10:46:59  jaaps
*    main: honour position filter from the .exp inputfile
*          attitude handling routines (iros_correctflux, iros_effetime)
* 	 moved to separate file iros_effetime.c
* 	 new parameter: putsbck (-d), set to restore subtarcted X-ray
* 	 sources to skyimage.
*
 * Revision 1.11  1997/01/31  08:26:30  jaaps
 *    iros_effetime: fixed several bugs - very short timewindows could be missed
 *    				     - timewindow exit with visible object was
 * 				       missed under (rare) conditions.
 * 		  added debug output, detailed report of exposure time computation.
 *
 * Revision 1.10  1996/12/18  11:24:53  jaaps
 *    update KeyRecord comment fields.
 *    do not use integral non-lin. corrections by default, code is still too
 *    much in development.
 *
 * Revision 1.9  1996/12/13  12:39:00  jaaps
 *    iros: get attitude filename from first eventfile listed in .exp file,
 *          can override this default with explicit parameter.
 *    iros: updated src_sslfromcat call (new ins parameter).
 *    	 added code for computing exposure time on a per source basis,
 * 	 earth obscuration may differ (somewhat) from source to source.
 *    iros: updateted src_catfromssl call (new ins parameter)
 *
 * Revision 1.8  1996/11/26  13:14:26  jaaps
 * non essential, cosmetic adjustments (no reason found in source).
 *
 * Revision 1.7  1996/11/14  13:25:46  jaaps
 *    main: default threshold value now 0.5.
 *
 * Revision 1.6  1996/10/09  14:07:58  jaaps
 *    iros: added parameter, "DNLCRCN" (-y) to control
 *          detector non-linearity corrections.
 *
 * Revision 1.5  1996/09/23  13:24:12  jaaps
 *    main: added phase parameter to cor_recon and iros_loop calls.
 *    main: default catalogfile's path now handled in src_readcatalog.
 *
 * Revision 1.4  1996/08/22  07:39:07  jaaps
 *    main: updated cor_createci call, pass filetype, WFC_RSYID.
 *
 * Revision 1.3  1996/07/05  09:40:29  jaaps
 * non essential, cosmetic adjustments (no reason found in source).
 *
 * Revision 1.2  1996/05/20  14:45:29  jaaps
 * iros: wrong handling of open error on input file, fixed.
 * iros: issue warning on instrument datafile override through parameter.
 * iros: issue warning when source catalog cannot be opened.
 * iros: reduced detector image extension changed to "rdi".
 * iros: all input parameters now in PRIMARY FITS header (HEAD req.).
 * iros_loop: parameter list change, thrshld, radius and irsmode now through rsy.
 * iros: improve source catalog lookup,
 *       added env, var. WFCENV_CAT to pinpoint catalog directoty.
 * iros: issue warning when source catalog cannot be opened.
 * iros: define response on TSPZ format input image.
 *        reconstructed sky = create TSPZ CIM and CIE images.
 *        sourcelist	 = ascii formatted list, written to logfile.
 *        reduced di	 = create TSPZ DIM image, must rename not to overwrite input.
 *        			   rdi created with name: "any-characters.n+1" if and only if
 * 			   inputname has form: any-characters.n,
 * 			   eg. W1_DIM_04APR96_073841.5 becomes W1_DIM_04APR96_073841.6.
 * iros: add limit (switch -s) on number of sources considered in the proces.
 *       specially if no actual sources are present, a lot of noise is subtracted.
 *
 * Revision 1.1  1996/04/25  21:03:54  sax
 * Initial revision
 *
********************************** - - ****************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <ctype.h>
#include <math.h>
#include <time.h>

#include "wfcglobals.h"
#include "fits.h"
#include "util.h"

#include "mask.h"
#include "detector.h"
#include "instrument.h"

#include "event.h"
#include "filter.h"
#include "expose.h"
#include "correlate.h"
#include "sources.h"
#include "analyse.h"

#include "iros.h"

#ifdef SRON   
   #include "head.h"
#endif  /* -------------- SRON */


static char *RCSID = "$Header: iros.c,v 1.37 99/02/01 17:45:26 jaaps Exp $";

#define C_CALLOC(s,a,b) secure_alloc (#s, a, b)
/**
*** #define C_CALLOC(a,b) calloc (a, b)
**/
 

int   gbl_debug  = 0;
char *gbl_creator= "$State: Exp $";

#ifndef PACKET_REVN2
#define  PACKET_REVN2 9999
#endif
int  gbl_revision= PACKET_REVN2;

typedef struct {
   char		*expfile,
      		*insfile,
      		*resfile,
      		*catfile,
      		*islfile,	/* external source input file.			*/
      		*xysilst,	/* external source input, x,y,si format.	*/
      		*attfile,	/* attitude data file.				*/
      		*title,
      		*chnnlb,	/* channelbounds, forced on detector image, TSPZ only */
		*fil_p,		/* position   					*/
      		*pntng, *sypntng,
		*tpsite, 
		*sdc;
  float  	thrshld, radius, atmhght, omitlvl;
  
  rpair		phase, gf, voigt, fudge;
  int		niros, cmode, irsmode, ofits, limitsl, 
     		inl, putsbck, slplane, psfrsltn, lsqfit, fixpos;
  rpair		mssep;
} INPPARREC;

static KeyRecord par_key[]= {
  {"RESFILE" , FTP(pchar, resfile, INPPARREC, PFC_OFILE), 0, "outputfile, reduced sky/det image, sourcelist"	},
  {"EXPFILE" , FTP(pchar, expfile, INPPARREC, PFC_IFILE), 0, "inputfile, detector image file"			},
  {"INSFILE" , FTP(pchar, insfile, INPPARREC, PFC_IFILE|PFC_HIDDEN), 0, "(.ins) file, overrides ref. in EXPFILE"},
  {"CATFILE" , FTP(pchar, catfile, INPPARREC, PFC_IFILE|PFC_HIDDEN), 0, "X-ray sources catalog"			},
  {"ISLFILE" , FTP(pchar, islfile, INPPARREC, PFC_IFILE), 0,
  		"imposed initial sourcelist to subtract, catalog format, can be .res"},
  {"XYSILST" , FTP(pchar, xysilst, INPPARREC, PFC_DFLT ), 0, "extra initial sourcelist to subtract, [name,]X,Y,si list"},
  {"ATTFILE" , FTP(pchar, attfile, INPPARREC, PFC_IFILE), 0, "attitude data file, overrides deflt path/name"	},
  {"TITLE"   , FTP(pchar, title  , INPPARREC, PFC_DFLT ), 0, "file title, description cq. comments"		},
  {"DECORUM" , FTP(int  , putsbck, INPPARREC, PFC_DFLT ), 0, "set to restore subtracted Xray source(s)"		},
  {"RADIUS"  , FTP(real , radius , INPPARREC, PFC_DFLT ), 0, "source identification, distance from cat. position"},
  {"OMITLVL" , FTP(real , omitlvl, INPPARREC, PFC_DFLT ), 0, "minimum detectorarea-fraction required for detection"},
  {"CMODE"   , FTP(int  , cmode  , INPPARREC, PFC_DFLT ), 0, "correlation mode, cf. correlate"			},
  {"NIROS"   , FTP(int  , niros  , INPPARREC, PFC_DFLT ), 0, "limit on number of iros iterations"		},
  {"IROS"    , FTP(int  , irsmode, INPPARREC, PFC_DFLT ), 0, "iros modes"					},
  {"SRCLIM"  , FTP(int  , limitsl, INPPARREC, PFC_DFLT ), 0, "limit number of sources considered to subtract."	},
  {"PSFRSLTN", FTP(int  ,psfrsltn, INPPARREC, PFC_DFLT ), 0, "psf resolution is (2*psfrsltn+1) times det.pixel."},
  {"SKYRSLTN", FTP(rpair, mssep  , INPPARREC, PFC_DFLT ), 0, "min.distance (pxls) to resolve 2 sources."	},
  {"THRSHLD" , FTP(real , thrshld, INPPARREC, PFC_DFLT ), 0, "detection threshold"				},
  {"CHNLSET" , FTP(pchar, chnnlb , INPPARREC, PFC_DFLT ), 0, "coerced channel range, tspz mode ONLY"		},
  {"P_FILTR" , FTP(pchar, fil_p  , INPPARREC, PFC_DFLT ), 0, "in(ex)clude section form detector image input"	},
  {"POINTING", FTP(pchar, pntng  , INPPARREC, PFC_DFLT ), 0, "force pointing:ra,dec,na."			},
  {"PSYAXIS" , FTP(pchar, sypntng, INPPARREC, PFC_DFLT ), 0, "as pointing, input is sat.y-axis ra,dec,na (QLA)"	},
  {"INLCRCN" , FTP(int  , inl    , INPPARREC, PFC_DFLT ), 0, "det. non-lin correction mode, value gives detail (max. 2)"			},
  {"ATMHGHT" , FTP(real , atmhght, INPPARREC, PFC_DFLT ), 0, "earth atmosphere thickness (km)"			},
  {"SIGFRAC" , FTP(pchar, sdc    , INPPARREC, PFC_DFLT ), 0, "minimal significance, fraction of most signif."	},
  {"OFITS"   , FTP(int  , ofits  , INPPARREC, PFC_DFLT ), 0, "if det.im.input is TSPZ-format, force FITS output"},
  {"SELPLANE", FTP(int  , slplane, INPPARREC, PFC_DFLT ), 0, "select energyband to be processed."		},
  {"LSQSLTN" , FTP(int  , lsqfit , INPPARREC, PFC_DFLT ), 0, "flux estimate form LSQ solution"			},
  {"DPHASE"  , FTP(rpair, phase  , INPPARREC, PFC_DFLT ), 0, "detector bin phase"				},
  {"VOIGT"   , FTP(rpair, voigt  , INPPARREC, PFC_DFLT ), 0, "override voigt function parameter, x and y"	},
  {"GSSNFCTR", FTP(rpair, gf     , INPPARREC, PFC_DFLT ), 0, "caldata gaussian param mult.factor"		},
  {"FUDGE"   , FTP(rpair, fudge  , INPPARREC, PFC_DFLT ), 0, "inl. calibration shift."				},
  {"FIXPOS"  , FTP(int  , fixpos , INPPARREC, PFC_DFLT ), 0, "keep source at position as in catalog."				},
  {WFC_TAPEARCHKEY,
  	       FTP(pchar, tpsite , INPPARREC, PFC_DFLT|PFC_HIDDEN), 0, "tape archive site name, su for SRON Utrecht"	}
};
#define npar_key (sizeof (par_key) / sizeof (par_key[0]))

/**
*** "XCHISQ", "chisq: %d(npix), %f(resolution), %d(niter), %f(zoom)"
**/

PARSW2KEYREC swmap[]= { "@", WFC_TAPEARCHKEY,
   			"%", "FUDGE"	,
			"a", "ISLFILE"	,	"A", "XYSILST"	,	
   			"b", "ATTFILE"	,
   			"c", "CMODE"	,
			"d", "DECORUM"	,
			"e", "CHNLSET"	,
			"f", "OFITS"	,
			"h", "ATMHGHT"	,
			"i", "TITLE"	,	"I", "INSFILE"	,
			"j", "SKYRSLTN"	,
			"k", "CATFILE"	,
			"l", "LSQSLTN"	,
			"m", "IROS"	,
			"n", "NIROS"	,
			"o", "OMITLVL"	,
			"p", "P_FILTR"	,
			"q", "PSFRSLTN" ,	"Q", "PSYAXIS"	,
			"r", "RADIUS"	,
			"s", "SRCLIM"	,
			"t", "THRSHLD"	,
			"u", "SELPLANE"	,
			"v", "FIXPOS"	,	"V", "VOIGT"	,
			"w", "SIGFRAC"	,
			"x", "POINTING"	,	"X", "PSYAXIS"	,
   			"y", "INLCRCN"	,
						"Z", "GSSNFCTR"	,
			"?",  "$RCSfile: iros.c,v $ $Revision: 1.37 $",
   			NULL, NULL	};

char     *reqArg[]= {"EXPFILE", "RESFILE", NULL};
cardinal NreqArg  = 2;

#ifdef SRON   
RETRIEVALLIST rtvl[]= {	{"a" , "ATTFILE" , "att"},
   			{"<" , "EXPFILE" , "exp"},
   			{">" , "RESFILE" , "res"},
			{NULL, NULL      , NULL }  };
#endif  /* -- SRON */

static WFC_SLLISTPTR iros_xysilst (char *xysilst, WFC_SLLISTPTR sl, WFC_INSTRUMENTPTR ins ) {
   
   WFC_SIMPLESOURCEPTR	t= NULL;
   char 		*s= xysilst, *u;
   float 		x, y, si;
   rpair  		cntr;
   cardinal		n, k;
   char			mess[256];
   
   cntr.x= 0.5*ins->cor.sn.x; cntr.y= 0.5*ins->cor.sn.y;
   if (xysilst != NULL && *xysilst != '\0') {
      
      k= 0;
      while (*s != '\0') {
	 if (t == NULL) t= ssl_newentry (SRCSTDSKYN);
	 
	 n= 0;
	 while (*s == ' ' || *s == ',') s++;
	 if (isalpha (*s)) {
	    u= s; while (!(*s == ',' || *s == '\0')) s++;
	    n= s-u+1;	    
	 }
	 while (*s == ' ' || *s == ',') s++; x = strtod (s, &s);
	 while (*s == ' ' || *s == ',') s++; y = strtod (s, &s); 
	 while (*s == ' ' || *s == ',') s++; si= strtod (s, &s); 
	 
	 if (!(*s == ' ' || *s == ',' || *s == '\0')) {
	    sprintf (mess, "iros_xysilst: could not completedly parse aux. sourcelist: %s\n",
		     xysilst);
	    wLog (DBG_WARNING, mess);
	    *s= '\0';
	    sprintf (mess, "                                   part succesfully read : %s<--\n",
		     xysilst);
	    wLog (DBG_CONT, mess);
	    break;
	 }
	 
	 if (n > 0) {
	    if (n > SOURCENAMEFIELDLEN) n= SOURCENAMEFIELDLEN;
	    if (n > 1) strncpy (t->name, u, n-1);
	    t->name[n-1]= '\0';
	 }
	 else
	    strcpy (t->name, "anonymous");	 
	 t->s0.flux = 0.0;
	 t->llc.x= (int) (x-3.0); t->llc.y= (int) (y-3.0); t->n.x= 6; t->n.y= 6;
	 t->s0.pos.x= t->llc.x+0.5-cntr.x; t->s0.pos.y= t->llc.y+0.5-cntr.y;      
	 t->spcm.type	= 1;
	 t->spcm.nh	= 21.5;
	 t->spcm.index	= (si > 0.0) ? si : 1.0;
	 t->status     |= (SC_IDENTIFIED|SC_LOCKED);
	 
	 if (sl == NULL) 
	    sl= sll_newlist (1);
	 else 
	    sl->limitn++;
	 t= ssl_insert (sl, t, FALSE);
      }
      if (t != NULL) {
	 if (t->fs.v != NULL) free (t->fs.v);
	 free (t);
      }
   }
   return sl;
}

WFC_SLLISTPTR iros_dfltsl (WFC_IROSPTR irs, WFC_EXPOSEPTR exp, WFC_INSTRUMENTPTR ins)
{
   
   WFC_SLLISTPTR	sl= NULL;
   WFC_SIMPLESOURCEPTR	t;
   WFC_CATALOGPTR	ct;
   char	  		mess[256]; 
   cardinal		k;
   float		fov;
   
   fov= (0.5*
	 sqrt((double)(ins->cor.sn.x*ins->cor.sn.x+ins->cor.sn.y*ins->cor.sn.y))
	 )/ins->focallength;
   
   if (irs->islfile != NULL && *irs->islfile != '\0') { 
      
      if (wft_isfits (irs->islfile, WFC_IRSID)) {
	 
	 WFC_IROSPTR i;
	 
	 if ((i= cor_open (irs->islfile, FALSE)) != NULL &&
	     i->ctl != NULL && i->ctl->n > 0) {
	    sl= src_sslfromcat (i->ctl, ins,
				i->rsy->exp->ra, i->rsy->exp->dec, i->rsy->exp->na);
	    wft_close (i->f);
	 }
	 if (i != NULL) {
	    if (i->rsy != NULL) {
	       if (i->rsy->exp != NULL) free (i->rsy->exp);
	       free (i->rsy);
	    }
	    free (i);
	 }
      }
      else {	 
	 if ((ct= src_readcatalog (NULL, irs->islfile, exp->ra, exp->dec, fov)) != NULL) {
	    if (ct->n > 0) sl= src_sslfromcat (ct, ins, exp->ra, exp->dec, exp->na);
	    if (ct->cel != NULL) free (ct->cel); free (ct);
	 }
      }
      if (irs->irsmode&IRS_USECATPOS) {
	 sprintf (mess, "iros_dfltsl: ignoring IRS_USECATPOS (bit %d) in IROS parameter\n",
		  IRS_USECATPOS);
	 wLog (DBG_WARNING, mess);
	 sprintf (mess, "             using data from %s instead.\n", irs->islfile);
	 wLog (DBG_CONT, mess);
	 
	 irs->irsmode &= ~IRS_USECATPOS;
      }
      if (sl == NULL || sl->n == 0) {
	 sprintf (mess, "iros_dfltsl: initial list \"%s\", has no pointsources in FOV!\n",
		  irs->islfile);
	 wLog (DBG_WARNING, mess);
      }
      if (sl != NULL) {
	 t= sl->top; 
	 for (k= 0; k!= sl->n; k++) {
	    if (!(t->status&SC_BACKGROUND)) t->status |= SC_LOCKED;
	    t= t->next;
	 }
      }
   }
   
   sl= iros_xysilst (irs->xysilst, sl, ins );
/**if ((irs->irsmode&IRS_FIXPOS) && sl != NULL)
      for (k= 0, t= sl->top; k!= sl->n; k++, t= t->next)
	 if (!(t->status&SC_BACKGROUND)) t->status |= SC_FIXPOS; ***/
   
   if (!(irs->irsmode&IRS_NOEXPSL) && exp->ctl != NULL) {
      for (k= 0; k!= exp->ctl->n; k++)
	 wft_btFset (exp->ctl->e, k, CR_FLUX, 0, 0.0);
      sl= src_sslfromcat (exp->ctl, ins, exp->ra, exp->dec, exp->na);
      sl->chrange= exp->bands[0];
   }
   if (exp->ctl != NULL) {
      if (exp->ctl->cel != NULL) free (exp->ctl->cel); free (exp->ctl);
      exp->ctl= NULL;
   }
   
   if (!(irs->irsmode&IRS_NOSRCCAT)) {
      
      char catalog[WFCMINPATHLENGTH], *s;
      
      exp->ctl= src_readcatalog (NULL, irs->catfile, exp->ra, exp->dec, fov);
      if (exp->ctl != NULL) {
	 
	 if (irs->irsmode&IRS_USECATPOS)
	    sl= src_sslfromcat (exp->ctl, ins, exp->ra, exp->dec, exp->na);
	 
	 if ((gbl_debug&DBG_VISIBMASK) >= DBG_L3) {
	    rpair center;
	    
	    center.x= 0.5*ins->cor.sn.x; center.y= 0.5*ins->cor.sn.y;
	    src_Logcatalog (exp->ctl, ins->focallength, center, exp->ra, exp->dec, exp->na);
	 }
      }	 
      else {
	 sprintf (mess,     "iros_dfltsl: cannot find source catalogfile \"%s\"\n", 
		  (irs->catfile != NULL) ? irs->catfile : "env: $"WFCENV_CATFILE);
	 wLog (DBG_WARNING, mess);
	 wLog (DBG_CONT   , "             check your \"WFC_CAT\" environment variable\n");
	 wLog (DBG_CONT   , "             use switch \"-kpath\" (param= catfile) to supply a catalogpathname\n");
	 wLog (DBG_CONT   , "          or use switch \"-m1\" to suppres search for catalog.\n");
	 irs->irsmode |= IRS_NOSRCCAT;
      }      
   }
   return sl;
}

void iros_restore (WFC_SLLISTPTR sl, WFC_RECSKYPTR rsy) {
   
   WFC_SIMPLESOURCEPTR	p;
   cardinal 		k, n0, i0, n1, i1, n2, i2, len[2];
   DATAPTR		fit;
   float		bg;
   
   if (sl != NULL && sl->n > 0) {
      
      n0= dta_slength (rsy->sky, 0); i0= dta_soffset (rsy->sky, 0);
      n1= dta_slength (rsy->sky, 1); i1= dta_soffset (rsy->sky, 1);
      n2= dta_slength (rsy->sky, 2); i2= dta_soffset (rsy->sky, 2);
      
      dta_section (rsy->sky, 2, 0, 1);
      
      p= sl->top;
      
      len[0]= p->fs.len.x; len[1]= p->fs.len.y;
      fit= dta_create ("fit", BXREAL, FALSE, 2, len);
      
      for (k= 0; k!= sl->n; k++) {
	 
	 if (!(p->status&SC_BACKGROUND)) {
	    dta_section (rsy->sky, 0, p->fs.llc.x, p->fs.len.x);
	    dta_section (rsy->sky, 1, p->fs.llc.y, p->fs.len.y);
	    
	    dta_setmem (fit, (void *) p->fs.f, p->fs.len.x*p->fs.len.y*sizeof (p->fs.f[0]));
	    dta_reshape (fit, 2, len);
	    
	    /***** locally fitted background, subtract ???	*****/
	    bg= p->s0.backgr; dta_vs (OADD, fit, -bg);	 
	    
	    dta_vv (OADD, rsy->sky, fit, NULL);
	 }
	 p= p->next;
      }
      dta_section (rsy->sky, 0, i0, n0);
      dta_section (rsy->sky, 1, i1, n1);
      dta_section (rsy->sky, 2, i2, n2);
      
      dta_destroy (fit);
   }
}

static double iros_dcds (char *s, char **t, cardinal flg) {
   
   double	p0, p1, f= 1.0;
   bool		nve= FALSE, err;
   
   if (*s == '+' || *s == '-') nve= *s++ == '-';
   
   p0= strtod (s, t); err= s == *t;
   s= *t;
   while (!(*s == ',' || *s == '\0')) {
      s++;
      p1= strtod (s, t); err|= s == *t; f /= 60.0; p0 += p1*f;
      s= *t;
   }
   if (flg == 0 && f != 1.0) p0 *= 15.0;  /* ra, hms format. */
   
   if (err) p0= 999;
   return (err || !nve) ? p0 : -p0;
}

iros_forcepntng (char *pntng, bool qla_p, WFC_EXPOSEPTR exp, WFC_INSTRUMENTPTR ins) {
   
   char		*s= pntng, rda[128], mess[256];
   double	v[3];
   cardinal	i= 0;
   
   v[0]= v[1]= v[2]= 999.0;
   
   while (*s != '\0') {
      if (*s != ',') {
	 pntng= s; v[i]= iros_dcds (pntng, &s, i); i++;
      }
      if (*s == ',') s++;
   }
   if (v[0] == 999.0) {
      wLog (DBG_WARNING, "iros_forcepntng: parse error in ra-part, using current value\n");
      v[0]= exp->ra;
   }
   if (v[1] == 999.0) {
      wLog (DBG_WARNING, "iros_forcepntng: parse error in dec-part, using current value\n");
      v[1]= exp->dec;
   }
   if (v[2] == 999.0) {
      wLog (DBG_WARNING, "iros_forcepntng: parse error in na-part, using current value\n");
      v[2]= exp->na;
   }
      
   if (qla_p) {
      float	ro;
      rpair	d;
      
      d.x= -ins->sim.det->align->align->dx/ins->focallength;
      d.y= -ins->sim.det->align->align->dy/ins->focallength;
      ro =  ins->sim.det->align->align->roll;
      jz_shiftPointing (d, ro, v+0, v+1, v+2);
   }
   exp->ra = v[0]; exp->dec= v[1]; exp->na = v[2];
   
   sprintf (mess, "iros_forcepntng: %s\n", frmt_rda (exp->ra, exp->dec, exp->na, rda));
   wLog (DBG_WARNING, mess);
   if (qla_p) {
   sprintf (mess,
	    "                 mis-alignment, dx= %.2f, dy= %.2f (arcmin.), dna= %.2f (deg.) corrected, \n",
	       60.0*WFC_RAD2DEG(atan (ins->sim.det->align->align->dx/ins->focallength)),
	       60.0*WFC_RAD2DEG(atan (ins->sim.det->align->align->dy/ins->focallength)),
	       ins->sim.det->align->align->roll);
      wLog (DBG_CONT, mess);
   }
}

void iros_header (WFC_EXPOSEPTR exp) {
   
   time_t	t_t;
   char		mess[256], ras[128], *s;
   
   wLog (DBG_CHAT, "\n---------------------------------------------------------------------\n");
   
   t_t = (time_t) ((exp->tstart - asla_cldj ("1/1/70", "0:0:0"))*WFC_SECpDAY);
   sprintf (mess, "observation: %s (wfc%d)  \"%s\"\n",
	    (exp->obsPeriod != NULL) ? exp->obsPeriod : "<no op>",
	    exp->wfc, 
	    (exp->object    != NULL) ? exp->object : "<no object>");
   wLog (DBG_CHAT, mess);
   sprintf (mess, " start time: %s(UT)\n", asctime (gmtime (&t_t)));
   if ((s= strchr (mess+1, '\n')) != NULL && *(s+1) == '(') *s= ' ';   
   wLog (DBG_CHAT, mess);
   sprintf (mess, "   duration: %.1f sec.\n",  exp->time);
   wLog (DBG_CHAT, mess);
   sprintf (mess, "   pointing: %s\n", frmt_rda (exp->ra, exp->dec, exp->na, ras));
   wLog (DBG_CHAT, mess);
   
   wLog (DBG_CHAT, "---------------------------------------------------------------------\n\n");
}

static char *strip_spaces (char *s) {
   
   char *b= s, *d;
   
   d= s; 
   if (d != NULL) while (*d) if (*s == ' ') s++; else *d++= *s++;
   
   return b;
}
     
main (int argc, char **argv)
{
   INPPARREC		par;
   
   FITS_HDU		*hdu;
   FITSEXTENSION 	*ext;
   WFC_SLLISTPTR	sl;
   WFC_CATALOGPTR	catp;
   WFC_FILTERPTR	fltr, rd_fltr;
   WFC_IROSREC		irs;
   WFC_EXPOSEPTR	exp;
   WFC_INSTRUMENTPTR	ins;
   cardinal		i, plane, insload, offset[3];
   char			mess[256], *s;
   bool			virg;
   
   ext= NULL;
   catp= NULL;
   
   memset ((void *) &par, 0, sizeof (INPPARREC));
   memset ((void *) &irs, 0, sizeof (WFC_IROSREC));
   
   /** -----------	Parameter defaults -----------	**/
   par.lsqfit = 1;   par.inl    = 1;	/** Use integral non-lin. data (form wfc#.det) **/
   par.putsbck= 0;   par.slplane= 0; 
   par.radius = 2.0; par.thrshld= 1.0;
   par.psfrsltn= 0;  par.omitlvl= 0.01;

   par.sdc     = NULL;
   
   par.phase.x= par.phase.y= 0.0;   par.gf.x   = par.gf.y   = 1.0;
   par.voigt.x= par.voigt.y= 0.0;   par.mssep.x= par.mssep.y= 3.0;
   
   par.atmhght= WFC_ATMHEIGHT; par.title  = "iros HEAD id";

   hdu= new_hdu    ((void *)&par, 1, 0, par_key, npar_key);
   wft_getparrev (argc, argv, NreqArg, reqArg, hdu, swmap, gbl_revision);
   
#ifdef SRON
   if (par.tpsite)
      dsp_dispatch (argv[0], rtvl, hdu, swmap);
#endif /* ->- SRON -<- */

   free (hdu); hdu= NULL;
   
   if (par.inl&1) par.irsmode |= IRS_USEINLSIM;
   if (par.inl&2) par.irsmode |= IRS_USEINL2SIM;
   if (par.inl&4) par.irsmode |= IRS_SPECIAL;
   if (par.inl&8) par.irsmode |= IRS_SHOWSKYRMS;
   
/* if (par.fixpos  == 1) par.irsmode |= IRS_FIXPOS; */
   if (par.putsbck == 1) par.irsmode |= IRS_RESTORED;
   if (par.lsqfit  == 1) par.irsmode |= IRS_DETLSQFIT;
   if (par.voigt.x > 0.0 || par.voigt.y > 0.0)  par.irsmode |= IRS_VOIGTPSF;
   
   if (par.omitlvl > 1.0) par.omitlvl= 1.0;
   if (par.omitlvl < 0.0) par.omitlvl= 0.0;
   if (par.psfrsltn > 1) {
      wLog (DBG_WARNING,
	    "iros: restriction, psf resolution limited to 1/3 of detectorpixel size.\n");
      par.psfrsltn= 1;
   }
   
   exp= exp_open (par.expfile, TRUE);
   if (strcmp (par.expfile, exp->f->myName) != 0 &&
       exp->f->ext->fileid == WFC_IRSID) {
      sprintf (mess, "iros: r(educed)d(etector)i(mage) input from \"%s\"\n", exp->f->myName);
      wLog (DBG_WARNING, mess);
   }
   if (par.insfile != NULL && *par.insfile != '\0') {
      if (exp->insfile != NULL && *exp->insfile != '\0') {
	 sprintf (mess, "iros: detector image \"%s\"\n", par.expfile);
	 wLog (DBG_WARNING, mess);
	 sprintf (mess, "       implicit instrument datafile: \"%s\"\n", exp->insfile);
	 wLog (DBG_CONT, mess);
	 sprintf (mess, " overruled by parameter INSFILE(-I): \"%s\"\n", par.insfile);
	 wLog (DBG_CONT, mess);
      }
      exp->insfile= par.insfile;
   }
   
   if (exp->f->ext != NULL && exp->f->ext->tspz != NULL) {
      if (par.chnnlb != NULL && *par.chnnlb != '\0') {
	 char *s= par.chnnlb;
	 int	e0, e1;
	 
	 if (isdigit (*s)) {
	    e0= e1= (int) strtod (s, &s); s++;
	    if (isdigit (*s)) e1= (int) strtod (s, &s);
	 }
	 if (*s != '\0') {
	    sprintf (mess, "iros: cannot fully parse -e option:  %s\n", par.chnnlb);
	    wLog (DBG_WARNING, mess);
	    sprintf (mess, "      energy bounds used are %d-%d (channels)\n",
		     exp->bands[0].L, exp->bands[0].H);
	 }
	 else {
	    exp->bands[0].L= e0; exp->bands[0].H= e1;
	 }
      }
      par.chnnlb= NULL;
   }
   
   if (par.ofits == 1 && exp->f->ext != NULL && exp->f->ext->tspz != NULL)
      wLog (DBG_WARNING, "iros: outputfile format forced to FITS\n");
   
   if (par.chnnlb != NULL && *par.chnnlb != '\0') 
      wLog (DBG_WARNING, "iros: set channel range option (-e) ignored, input is NOT tspz\n");
   
   if (par.fil_p != NULL && exp->fil_p != NULL) {
      sprintf (mess, "iros: overriding detectorimage p_fltr (-p) parameter \"%s\"\n", exp->fil_p);
      wLog (DBG_ERROR, mess);
      sprintf (mess, "      results may not be properly normalised!!!\n");
      wLog (DBG_CONT, mess);
   }
   fltr= filter_position (NULL, strip_spaces (exp->fil_p));   
   fltr= filter_position (fltr, strip_spaces (par.fil_p));   
   rd_fltr= (par.fil_p != NULL) ? fltr : NULL;
   exp->fil_p= filter_area2asc (fltr);
   
   insload = INSMASK|INSBMASK|INSMASKDFT|INSDETECTOR;
   if (fltr == NULL || fltr->p_i == NULL) insload |= INSCF;   
   if (par.irsmode&IRS_SPECIAL) insload |= INSCALDNL;
   
   ins= instrument_get (exp->insfile, NULL, insload);      
   if ((insload&INSCF) == 0) {
      sprintf (mess, "iros: recomputing (simple) Tk factors for \"%s\"\n", exp->insfile);
      wLog (DBG_WARNING, mess);
      sprintf (mess, "      caused by detectorsection filter: \"%s\"\n", 
	       (exp->fil_p!= NULL) ? exp->fil_p : ">>cannot be empty!!<<");
      wLog (DBG_CONT, mess);
      
      ins_makecf (ins, fltr);
   }
   if (par.fudge.x != 0.0 || par.fudge.y != 0.0)
      if (ins != NULL && ins->sim.det != NULL && ins->sim.det->inl != NULL) {
	 ins->sim.det->inl->dx_8kev= par.fudge.x;
	 ins->sim.det->inl->dy_8kev= par.fudge.y;
	 wLog (DBG_WARNING, "iros: removed inl. data, faking..\n");
	 ins->sim.det->inl->inl= NULL;
      }
   
   if (par.sypntng != NULL) {
      if (par.pntng != NULL)
	 wLog (DBG_WARNING,
	    "iros: ignored \"POINTING\"(-x) value, overridden by \"PSYAXIS\"(-Q or -X)\n");
      par.pntng= par.sypntng;
   }   
   if (par.pntng != NULL)
      iros_forcepntng (par.pntng, par.sypntng != NULL, exp, ins);

   if (par.gf.x != 1.0 || par.gf.y != 1.0) {
      if (ins->sim.det != NULL && ins->sim.det->energy_calib != NULL) {
	 sprintf (mess, "iros: *@#$%! you are tampering the calibration data!!!\n",
		  exp->insfile);
	 wLog (DBG_WARNING, mess);
	 sprintf (mess, "      *@#$%! gaussian factor (%.2f,%.2f)\n",
		  par.gf.x, par.gf.y);
	 wLog (DBG_CONT, mess);
	 for (i= 0; i!= ins->sim.det->energy_calib->n; i++) {
	    ins->sim.det->energy_calib->energy_calib[i].resolution0[0] *= par.gf.x;
	    ins->sim.det->energy_calib->energy_calib[i].resolution0[1] *= par.gf.y;
	 }
      }
   }
   if (par.voigt.x != 0.0 || par.voigt.y != 0.0) {
      sprintf (mess, "iros: *@#$%! you are tampering the calibration data!!!\n", exp->insfile);
      wLog (DBG_WARNING, mess);
      sprintf (mess, "      *@#$%! voigt parameter set to (%.2f,%.2f)\n", par.voigt.x, par.voigt.y);
      wLog (DBG_CONT, mess);
      for (i= 0; i!= ins->sim.det->energy_calib->n; i++) {
	 ins->sim.det->energy_calib->energy_calib[i].vgt[0] = par.voigt.x;
	 ins->sim.det->energy_calib->energy_calib[i].vgt[1] = par.voigt.y;
      }
   }
   
   if (par.irsmode&IRS_NOEXPSL) exp->ctl= NULL;   
   
   irs.f      = NULL;		irs.rsy    = NULL; 
   irs.hdu    = NULL;		irs.ctl	   = NULL;
   irs.attfile= NULL;		irs.limitsl= par.limitsl;
   irs.niros  = par.niros;	irs.thrshld= par.thrshld;
   irs.radius = par.radius;	irs.irsmode= par.irsmode;
   irs.title  = par.title;	irs.islfile= par.islfile;
   irs.xysilst= par.xysilst;	irs.catfile= par.catfile;
   irs.atmhght= par.atmhght;	irs.mssep  = par.mssep;
   irs.omitlvl= par.omitlvl;	irs.psfrsltn= par.psfrsltn;
   irs.putsbck= par.putsbck;
   irs.chnnlb = par.chnnlb;	irs.pntng  = par.pntng;
   irs.inl    = par.inl;	irs.slplane= par.slplane;
   irs.voigt  = par.voigt;	irs.gf     = par.gf;
   irs.bgmodel= exp_bgfovname (NULL);
   irs.str_sdc= par.sdc;
   s= irs.str_sdc;
   if (s != NULL) irs.sdc[0] = strtod (s, &s); 
   if (s != NULL && *s++ == ',') irs.sdc[1] = strtod (s, &s); 
   if (s != NULL && *s++ == ',') irs.sdc[2] = strtod (s, &s); 
   if (irs.sdc[2] > 0.5) irs.irsmode|= IRS_PERSISTENT;

   if (exp->ctl != NULL) irs.catfile= exp->ctl->name;
   
   if (exp->f->ext->fileid == WFC_IRSID) {
      
      cardinal n[3];
      
      irs.rsy = (WFC_RECSKYPTR) C_CALLOC (iros, 1, sizeof (WFC_RECSKYREC));
      n[0]= dta_axis (ins->cor.mskdft, 0); 
      n[1]= dta_axis (ins->cor.mskdft, 1);
      n[2]= 2;	    
      irs.rsy->sky = dta_create ("sky", BXREAL, TRUE, 3, n);
      offset[0]= offset[1]= 0;
      
      irs.irsmode|= IRS_NOEXPSL;	/* DO NOT USE previously found sourcelist again. */
      irs.irsmode|= IRS_AGGRESV;	/* catalog identification not required.		 */
   }
   
   virg = TRUE;
   plane= 0;
   if (par.slplane > exp->nplanes) par.slplane= exp->nplanes;
   if (par.slplane < 0           ) par.slplane= 0;
   sl= iros_dfltsl (&irs, exp, ins);
   
   iros_header (exp);
   if (exp->nplanes == 0) {
      sprintf (mess,  "iros: NO detector planes in input %s.\n", exp->f->myName);
      wLog (DBG_ERROR, mess);
      i= exp->f->ext            != NULL &&
	  exp->f->ext->d.naxis   >= 2   &&
	  exp->f->ext->d.axis[0] > 0    &&
	  exp->f->ext->d.axis[1] > 0;
      if (!i)
	 wLog (DBG_FATAL, "      incomprehensible inputfile format.\n");
      
      wLog (DBG_WARNING,
	    "iros: tentatively continuing as file appears to contain data anyway.\n");
      
      exp->nplanes= 1;
      exp->bands = (TiLwHh *) calloc (exp->nplanes, sizeof (TiLwHh));
      exp->nevent= (int    *) calloc (exp->nplanes, sizeof (int));
      exp->sum   = (float  *) calloc (exp->nplanes, sizeof (float));
      
      exp->bands[0].L= 1;      exp->bands[0].H= 31;
      exp->nevent[0] = 0;      exp->sum[0]    = 0.0;
      if (exp->esize.x <= 0.0) exp->esize.x = 0.375;
      if (exp->esize.y <= 0.0) exp->esize.y = 0.375;
      if (exp->time    <= 0.0) exp->time= 1.0;
   }

   while (plane != exp->nplanes) {
      
      if (par.slplane == 0 || plane == par.slplane-1) {
	 sprintf (mess, "iros: plane %d (channels %d - %d)\n",
		  plane+1, exp->bands[plane].L, exp->bands[plane].H);
	 wLog (DBG_CHAT, mess);
	 
	 exp_readplane (exp, ins, rd_fltr, plane, 1);
	 if (exp->f->ext->fileid == WFC_IRSID) {
	    offset[2]= 2*plane; 
	    dta_section (irs.rsy->sky, 0, 0, dta_axis (&exp->f->ext->d, 0));
	    dta_section (irs.rsy->sky, 1, 0, dta_axis (&exp->f->ext->d, 1));
	    dta_section (irs.rsy->sky, 2, 0, 2);
	    dta_read (exp->f, irs.rsy->sky, exp->f->ext, offset);
	    dta_clrsection (irs.rsy->sky);
	 }
	 else
	    irs.rsy= cor_recon (irs.rsy, exp, ins, par.phase, 0.0, par.cmode);
	 
	 if (virg) {      
	    irs.rsy->fil_p = par.fil_p; irs.rsy->cmode= par.cmode; 
	    irs.rsy->ofits = par.ofits; irs.rsy->smd  = 0.0;
	    irs.rsy->bphase= par.phase; irs.rsy->exp  = exp;
	    
	    if (gbl_debug&DBGMDL_IRS) {
	       wft_createimage ("iros", WFC_SKYID, NULL, irs.rsy->sky);
	       wLog (DBG_INFO, "iros: created testimage \"iros.sky\"\n");
	    }
	 }
	 
	 wft_createimage ("used-exp", WFC_EXPID, NULL, irs.rsy->exp->di);
	  
	 sl= iros_loop (sl, &irs, ins, fltr, plane);
	 
	 if (par.irsmode&IRS_RESTORED) iros_restore (sl, irs.rsy);
	 if (virg) {
	    if (par.ofits == 1) exp->f->ext->tspz= NULL;
	    iros_creaters (par.resfile, par.title, "iros", &irs, exp, WFC_IRSID);
	 }
	 
	 ext= wft_findextension (irs.f, NULL, FTMAIN, 0, 0);  
	 dta_section (&ext->d, 2, 2*plane, dta_axis (irs.rsy->sky, 2));
	 dta_write (irs.f, ext, irs.rsy->sky, NULL);
	 
	 if (exp->f->ext->tspz == NULL) {
	    ext= wft_findextension (irs.f, "rdi", FTIMAGE, 0, 0);  
	    dta_section (&ext->d, 2, plane, 1);
	    dta_write (irs.f, ext, exp->di, NULL);
	 }
	 
	 if ((par.irsmode&IRS_NOSRCCAT) && (par.irsmode&IRS_PIXAPPRCH)) {
	    WFC_CATALOGPTR cp;
	    float	   fov;
	    double	   t;
	    
	    t= ins->cor.sn.x*ins->cor.sn.x+ins->cor.sn.y*ins->cor.sn.y;
	    fov= (0.5*sqrt(t))/ins->focallength;	 
	    if ((cp= src_readcatalog (NULL, par.catfile, exp->ra, exp->dec, fov)) != NULL)
	       ana_identify (sl, cp, ins, irs.radius);
	 }
	 if (sl != NULL && catp == NULL) 
	    catp= src_createcatbt ("WFC_Sourcelist", exp->nplanes, exp->bands, sl->n);
	 src_catfromssl (catp, sl, plane, ins);
	 
	 if (exp->f->ext->tspz        != NULL &&
	     (gbl_debug&DBG_VISIBMASK) == 0      ) gbl_debug |= DBG_INFO;
	 src_showsl ("iros: final sourcelist", sl, ins->focallength, NULL, 3, DBG_CHAT);
	 
	 sll_clean (sl);	 
	 virg= FALSE;
      }
      plane++;
   }
   
   if (exp->f->ext->tspz == NULL) {
      
      iros_effetime    (par.attfile, catp, ins, exp, irs.atmhght);  
      iros_correctflux (catp, ins, exp);
      if (catp != NULL && catp->n > 0) src_writesrclist (irs.f, catp);
   }
   wft_close (irs.f);
}
