/** $Header: /home/sax/sources/DIST/src/iros/RCS/iros_loop.c,v 1.34 1998/06/18 07:42:11 jaaps Exp $
********************************** - - ****************************************
* 						   
*         _/_/_/_/_/_/    _/_/_/    _/_/      _/_/       SRON Utrecht
*      _/_/_/_/  _/_/  _/_/_/_/_/  _/_/_/  _/_/_/    
*     _/_/_/        _/_/      _/_/  _/_/_/_/_/       _/     _/ _/_/_/_/ _/_/_/
*      _/_/_/_/_/  _/_/_/_/_/_/_/    _/_/_/         _/     _/ _/     _/_/
*           _/_/_/_/_/_/_/_/_/_/  _/_/_/_/_/  _/_/ _/  _/ _/ _/_/_/ _/      
*  _/_/  _/_/_/_/_/_/      _/_/_/_/_/  _/_/_/     _/_/ _/_/ _/     _/_/  
* _/_/_/_/_/_/  _/_/      _/_/_/_/      _/_/     _/     _/ _/       _/_/_/   
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* Use	      :	iros_loop
*
* Parameters  :	
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* Dependencies:	
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* Description :	extract	sources from detector image
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* $Log: iros_loop.c,v $
 * Revision 1.34  1998/06/18  07:42:11  jaaps
 * non essential, cosmetic adjustments (no reason found in source).
 *
* Revision 1.33  1998/05/13 10:28:36  jaaps
*    iros_loop: implemented significance threshold source detection,
*    	      threshold is fraction of most significant source in fov.
*
* Revision 1.32  1997/12/03 08:48:26  jaaps
* non essential, cosmetic adjustments (no reason found in source).
*
* Revision 1.31  1997/11/13 16:38:15  jaaps
*   iros_loop: shield debug output!!.
*
* Revision 1.30  1997/11/12 14:39:12  jaaps
* non essential, cosmetic adjustments (no reason found in source).
*
* Revision 1.29  1997/09/23 12:31:25  jaaps
*    disabled X-window user-interaction.
*    iros_background: use background 'name' as defined in sources.h
*
* Revision 1.28  1997/09/19 13:44:00  jaaps
*   iros_background: set spectral type field to STBACKGROUND.
*
* Revision 1.27  1997/09/16 12:48:46  jaaps
*   iros_loop: separate sources and background in reports.
*
* Revision 1.26  1997/09/08 08:25:01  jaaps
*   iros_loop: update ana_createpsf parameters, added psf-resolution.
*   	     estimate and subtract background in loop.
*
* Revision 1.25  1997/07/01 12:56:30  jaaps
*    iros_loop: merge sourcedetections from current and previous loop,
*               if these are closer then WFC_IROSPTR::mssep
* 	      (parameter SKYRSLTN) pixels.
*
* Revision 1.24  1997/06/26 15:14:29  jaaps
* non essential, cosmetic adjustments (no reason found in source).
*
* Revision 1.23  1997/06/04 15:21:47  jaaps
*   iros_loop: correctly report number of corrected sources, entries with flux = 0.0
*   		must not be reported, confusion.
*
* Revision 1.22  1997/05/23 10:24:12  jaaps
*    iros_loop: loop-stop criterium based on rms decline fails in situation
*               with few events, typically burst analysis, with (very)
* 	      short (~seconds) integration time.
*
* Revision 1.21  1997/05/02 15:33:18  jaaps
* non essential, cosmetic adjustments (no reason found in source).
*
* Revision 1.20  1997/04/28 08:49:18  jaaps
*   iros_loop: update rms value after iros_solve!!.
*
* Revision 1.19  1997/04/23 11:28:04  jaaps
*    iros_loop: honour the limit on the maximium number of sources that can be detected,
*    	      not just in the first loop, but apply to all loops.
*
* Revision 1.18  1997/04/11 15:21:45  jaaps
*   iros_reduce: update exp_addsl call, parameter change.
*
* Revision 1.17  1997/03/10 08:49:29  jaaps
*    iros_loop: fixing.
*
 * Revision 1.16  1997/02/27  10:48:50  jaaps
 *   new fit functions, aps_fitfpbw_sl.
 *
 * Revision 1.15  1997/01/31  08:26:31  jaaps
 *    iros_reduce: check sourcelist dereferences (NULL).
 *    iros_loop  : no longer check source-appearance (ana_squaretest),
 *    		if sources were checked aginst cataclog entries.
 *
 * Revision 1.14  1996/12/18  11:24:54  jaaps
 *    update exp_subtractsl and exp_addsl calls, new parameter fot inl corrections.
 *
 * Revision 1.13  1996/12/13  12:39:01  jaaps
 *    iros_additer: fix overrun problems with too many sources.
 *
 * Revision 1.12  1996/11/26  13:14:27  jaaps
 * non essential, cosmetic adjustments (no reason found in source).
 *
 * Revision 1.11  1996/11/14  13:25:47  jaaps
 * non essential, cosmetic adjustments (no reason found in source).
 *
 * Revision 1.10  1996/10/10  07:34:39  jaaps
 * iros_loop: limited iterations on position and flux corrections
 *            in 'sky-oriented' search.
 *
 * Revision 1.9  1996/10/09  14:13:09  jaaps
 *    iros_delta: add check for sourcepositions running out the FOV,
 *    	       due to less tight check in ana_search.
 * 	       (to catch, at some point, Sco-X1 at [2,y]).
 *
 * Revision 1.8  1996/09/24  11:42:18  jaaps
 *    iros_loop.c: moved debug-output files within debug brackets.
 *
 * Revision 1.7  1996/09/23  13:24:13  jaaps
 *    iros_delta:  erroneously used physical sky image size, need to use
 *    		actual sky dimensions.
 * 		seems to be the main course for most of iros'es failing.
 *
 * 		computation of delta-position refined, on very strong sources
 * 		(Sco-X1) the loop (subtract position-correlate-delta position)
 * 		was unstable.
 *
 * 		use the psf as weight-factors in the position correction
 * 		computation.
 *
 * Revision 1.6  1996/08/22  07:39:08  jaaps
 * non essential, cosmetic adjustments (no reason found in source).
 *
 * Revision 1.5  1996/07/05  09:40:30  jaaps
 *    all: defined some cpp function-macros, to implement the non-HEAD vs. HEAD
 *         differences in interactive i/o
 *
 * Revision 1.4  1996/06/11  13:47:14  markjoe
 * Added HEAD interactivity.
 *
 * Revision 1.3  1996/05/21  11:52:00  jaaps
 *    iros_check: suppress per source pixel data output, restrict on gbl_debug > 0.
 *
 * Revision 1.2  1996/05/20  14:52:48  jaaps
 *    iros_reduce: add sourcelist update
 *
 * Revision 1.1  1996/04/25  21:03:54  sax
 * Initial revision
 *
********************************** - - ****************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>


#include "wfcglobals.h"
#include "fits.h"
#include "util.h"

#include "mask.h"
#include "detector.h"
#include "instrument.h"

#include "event.h"
#include "expose.h"
#include "correlate.h"
#include "sources.h"
#include "analyse.h"
#include "iros.h"

void aps_fitfpbw_sl (WFC_SLLISTPTR, WFC_INSTRUMENTPTR);
bool aps_fitpsffpbw (WFC_SIMPLESOURCEPTR, WFC_INSTRUMENTPTR);

static char *RCSID = "$Header: /home/sax/sources/DIST/src/iros/RCS/iros_loop.c,v 1.34 1998/06/18 07:42:11 jaaps Exp $";

/**
***   Interactive IO - no longer used.
***
***#ifdef HEAD_DISABLED      
***#  define HEAD_PRINTF(y,x) HEAD_printf(x)
***#  define HEAD_PRMSCNF1(s0,s1,x0,s2)    HEAD_prompt_and_scanf(s0, s1, x0)
***#  define HEAD_PRMSCNF2(s0,s1,x0,x1,s2) HEAD_prompt_and_scanf(s0, s1, x0, x1)
***#  define HEAD_PRMGETS(s0,s1,x,s2)      sprintf(s0, s1, x); HEAD_prompt_and_gets(s0, s2);
***#else
***#  define HEAD_PRINTF(y,x) wLog(y, x)
***#  define HEAD_PRMSCNF1(s0,s1,x0,s2)    fprintf (WFCLOGF, s0); scanf (s1, x0)    ; gets (s2)
***#  define HEAD_PRMSCNF2(s0,s1,x0,x1,s2) fprintf (WFCLOGF, s0); scanf (s1, x0, x1); gets (s2)
***#  define HEAD_PRMGETS(s0,s1,x,s2)      fprintf (WFCLOGF, s1, x); gets (s2);
***#endif
**/

/**
*** Debuglevel for generation of "==" lines, rieks used these to calibrate the
*** gaussian component of the detectorresponse.
**/
#define IRS_GSNDRSPCALL	4

/**
*** Detectorarea factor to apparent detectorarea for diffuse skybackground.
**/
#define IRS_BGDAREAFCTR	1.25

/**
*** Default limit on iterations, may be overridden by parameter 'NIROS'.
**/
#define ITRTNLIMIT	15

/**
*** the jointwidth between the tiles in the (debug, trace) output of small
*** images (tiles) over the iros process.
**/
#define TILEJOINTWIDTH	2


#define C_CALLOC(s,a,b) secure_alloc (#s, a, b)
/**
*** #define C_CALLOC(s,a,b) calloc (a, b)
**/

#define ABS(a) (((a) >= 0.0) ? (a) : -(a))


#define DRMSEPSILON 0.001

typedef struct {
   cardinal n, Slim, Llim;
   DATAPTR  tile;
} TILEBOX_REC, *TILEBOX_PTR;


static void iros_position (WFC_SLLISTPTR sl) {
   
   WFC_SIMPLESOURCEPTR t, u;
   rpair		msp;
   
   msp.x= msp.y= 1.0;
   if (sl != NULL && sl->chrange.L == 0) {      
      sll_merge (sl, msp, TRUE);
   }
}


TILEBOX_PTR iros_inittile (cardinal niter, WFC_SLLISTPTR sl) {
   
   cardinal 	l[2];
   TILEBOX_PTR	rv= NULL;
   
   if (sl != NULL && sl->n > 0 && sl->top != NULL && niter > 0) {
      rv= (TILEBOX_PTR) C_CALLOC(iros_inittile, 1, sizeof(TILEBOX_REC));
      rv->n    = 0;
      rv->Slim = sl->n;
      rv->Llim = niter;
      l[0]    = 2*rv->Slim*(sl->top->fs.len.x+1+TILEJOINTWIDTH);
      l[1]    =   rv->Llim*(sl->top->fs.len.y+TILEJOINTWIDTH);
      
      rv->tile= dta_create ("tiles", BXREAL, TRUE, 2, l);
   }
   return rv;
}

TILEBOX_PTR iros_addtile (TILEBOX_PTR tb, WFC_SLLISTPTR sl, cardinal loopix, cardinal looplimit) {
   
   WFC_SIMPLESOURCEPTR  t;
   DATAPTR		a;
   cardinal		i, n, x, l[2];
   
   if (sl == NULL || sl->n == 0 || sl->top == NULL) return tb;
   if (tb == NULL)
      tb= iros_inittile (looplimit, sl);
   
   t= sl->top;
   
   n   = t->fs.len.x*t->fs.len.y;   
   if (n <16) return;
   
   if (loopix >= tb->Llim) return;
   
   dta_section (tb->tile, 1, loopix*(t->fs.len.y+TILEJOINTWIDTH), t->fs.len.y);
   
   l[0]= t->fs.len.x; l[1]= t->fs.len.y;
   a= dta_create ("iros_addstage", BXREAL, FALSE, 2, l);   
   for (i= 0; i!= sl->n && i!= tb->Slim; i++) {
      
      if (!(t->status&SC_BACKGROUND)) {
	 x= 2*i*(t->fs.len.x+1+TILEJOINTWIDTH);      
	 dta_section (tb->tile, 0, x, t->fs.len.x);
	 dta_setmem (a, (void *) t->fs.v, n);      dta_vv (OCOPY, tb->tile, a, NULL);
	 
	 dta_section (tb->tile, 0, x+1+t->fs.len.x, t->fs.len.x);
	 dta_setmem (a, (void *) t->fs.f, n);      dta_vv (OCOPY, tb->tile, a, NULL);
      }
      t= t->next;
   }
   dta_destroy (a);
   return tb;
}

DATAPTR iros_reduce (DATAPTR	   accu,
		     WFC_SLLISTPTR   sl, WFC_IROSPTR irs  ,
		     WFC_EXPOSEPTR  exp, cardinal    plane, WFC_INSTRUMENTPTR ins,
		     WFC_FILTERPTR  fltr)
{
   cardinal		i, n, k, LIMIT, flg;
   char			name[256];   

   n= 0;
   
   if ((gbl_debug&DBG_VISIBMASK) >= DBG_L2)
      src_showsl ("iros_reduce: subtracting ", sl, ins->focallength, NULL, 3, DBG_L2);
   
   flg= 0;
   if (irs->irsmode&IRS_USEINLSIM)  flg|= XP_USEINLDATA;
   if (irs->irsmode&IRS_USEINL2SIM) flg|= XP_USEINL2DATA;
   if (irs->irsmode&IRS_NODETPSF)   flg|= XP_NODETPSF;;

   if (accu != NULL) dta_vs (OINIT, accu, 0.0);
   accu= exp_addsl (accu, exp, plane, ins, fltr, sl, flg);
   dta_clrsection (exp->di); 
   if (accu != NULL) 
      dta_vvv (OSUB, exp->di, exp->di, NULL, accu, NULL);
   irs->rsy= cor_recon (irs->rsy, exp, ins, irs->rsy->bphase, 0.0, FCOR_NOERROR);
   
   if (sl != NULL && (irs->irsmode&IRS_PERSISTENT)) {
      
      WFC_SIMPLESOURCEPTR t= sl->top;  

      for (i= 0; i!= sl->n; i++) {
	 if (!(t->status&SC_BACKGROUND)) t->status|= SC_PERSISTENT; t= t->next;
      }
   }   
   return accu;
}

WFC_SLLISTPTR iros_combine (WFC_SLLISTPTR sl, WFC_SLLISTPTR new, WFC_IROSPTR irs) {
   
   WFC_SIMPLESOURCEPTR	A, t;
   
   if (sl == NULL) 
      sl= new;
   else if (new != NULL && new->n > 0) {      /** insert ring 'new' in 'sl'. **/
      A			  = sl->top;
      if (A->prev->status&SC_BACKGROUND)
	 A= A->prev;
      
      t                   = A->prev;      
      A->prev->next       = new->top;
      new->top->prev->next= A;
      A->prev             = new->top->prev;
      new->top->prev      = t;
      
      sl->n += new->n;
   }
   sll_merge (sl, irs->mssep, TRUE);

   if (irs->limitsl > 0 && sl->n > irs->limitsl) sll_limit (sl, irs->limitsl);
   return sl;
}

static WFC_SLLISTPTR iros_background (WFC_SLLISTPTR sl, WFC_INSTRUMENTPTR ins, float tdcr) {
   
   WFC_SIMPLESOURCEPTR  t, bg;
   cardinal		i, status;
   float		tscr, area;
   char			mess[256];

   bg  = NULL;   tscr= 0.0;
   
   if (sl == NULL) sl=  sll_newlist (1);
   
   t   = sl->top;  
   for (i= 0; i!= sl->n; i++) {
      if (!(t->status&SC_BACKGROUND)) tscr+= t->detcnts;
      
      if (t->status&SC_BACKGROUND) bg= t;
      t= t->next;
   }

   if (bg == NULL) {      
      if (sl->n >= sl->limitn) sl->limitn= sl->n+1;
      bg= ssl_newentry (0);
      bg->status= SC_BACKGROUND|SC_IDENTIFIED;
      strcpy (bg->name, SC_DFLTBGIDENT);
      bg->s0.flux   = 0.0;
      bg->spcm.type = STBACKGROUND;
      bg->spcm.nh   = 0.0;		bg->spcm.index= 0;
      
      bg->psf= psf_psf (NULL, &ins->sim.esize, ins, bg, &sl->chrange, 0, &status);
      
      ssl_insert (sl, bg, FALSE);
   }
   if (sl->n == 1 || tscr > 0.0) {
      area= 0.0;
      if (ins != NULL && ins->sim.det != NULL) area= IRS_BGDAREAFCTR*ins->sim.det->dcdtea;
      
      bg->s0.flux= (tdcr>tscr && area>0.0) ? (tdcr-tscr)/area : 0.0;
      
      if ((gbl_debug&DBGMDL_IRS) && (gbl_debug&DBG_VISIBMASK) >= DBG_L2) { 
	 sprintf (mess,
		  "iros_background: tdcr= %f c/s, tscr= %f c/s.  background= %f c/s.cm^2 (a= %.2f cm^2)\n",
		  tdcr, tscr, bg->s0.flux, area);
	 wLog (DBG_L2, mess);
      }
   }
   return sl;
}

void iros_gsnreport (WFC_SLLISTPTR sl, WFC_INSTRUMENTPTR ins, TiLwHh *chn, float d_rms, float adsum, float perc) {
   
   WFC_SIMPLESOURCEPTR	ssp;
   char			mess[256];
   cardinal		i;
   
   if ((gbl_debug&DBGMDL_IRS) && (gbl_debug&DBG_VISIBMASK) >= IRS_GSNDRSPCALL) {
      if (sl == NULL && ins != NULL) {
	 sprintf (mess,
		  "== channel %d - %d.  gaussian sigma: %.2f %.2f\n",
		  (chn) ? chn->L : 0, (chn) ? chn->H : 0,
		  ins->sim.det->energy_calib->energy_calib[(chn) ? chn->L : 0].resolution0[0],
		  ins->sim.det->energy_calib->energy_calib[(chn) ? chn->L : 0].resolution0[1]);
	 wLog (IRS_GSNDRSPCALL, mess);
	 sprintf (mess,
		  "== rms        det.sum (  %%  )     x (d 100),  y  (d 100)  flux (d 1000)    bg  (d 1000)   F\n");
	 wLog (DBG_CONT, mess);
	 wLog (DBG_CONT, "==\n");
	 return;
      }
      
      if (sl->n > 0) {	 
	 sprintf (mess, "== %8.4f %9.1f (%5.1f%%)\n", d_rms, adsum, perc);
	 wLog (IRS_GSNDRSPCALL, mess);
	 ssp= sl->top;
	 for (i= 0; i!= sl->n; i++) {
	    sprintf (mess,
		     "==    %.2f (%.2f) %.2f (%.2f) %.4f (%.4f) %.4f (%.4f) %.4f\n",
		     ssp->s0.pos.x , 100.0*ssp->s0.d_pos.x  ,
		     ssp->s0.pos.y , 100.0*ssp->s0.d_pos.y  ,
		     ssp->s0.flux  , 1000.0*ssp->s0.d_flux  ,
		     ssp->s0.backgr, 1000.0*ssp->s0.d_backgr, 
		     ssp->s0.F);
	    wLog (DBG_CONT, mess);
	    ssp= ssp->next;
	 }
      }
   }
}

WFC_SLLISTPTR iros_prune (cardinal lc, WFC_SLLISTPTR sl, WFC_IROSPTR irs, WFC_INSTRUMENTPTR ins) {

   float 		psig= 0.0;
   WFC_SIMPLESOURCEPTR	t;
   cardinal		i;
   bool			ml;
   char			mess[256];
   
   ml= (gbl_debug&DBGMDL_IRS) && (gbl_debug&DBG_VISIBMASK) >= DBG_L3;
   
   if (sl != NULL && sl->n > 0) {
      
      if (ml) {sprintf (mess, "iros_prune: %d sources\n", sl->n); wLog (DBG_L3, mess);}
      
      psig= 5.0;
      if ((t= sl->top) != NULL)
	 psig= t->s0.signif*irs->sdc[0];
      if (lc > 1 && irs->sdc[1] > 0.0) psig= irs->sdc[1];
      
      for (i= 0; i!= sl->n; i++) {
	 
	 if (ml) {
	    sprintf (mess, "            %12.12s @ %8.2f sigma ", t->name, t->s0.signif);
	    wLog (DBG_L3, mess);
	 }
	 if (!(t->status&SC_BACKGROUND)) {
	    if (t->status&(SC_CROP|SC_IDENTIFIED|SC_LOCKED)) {
	       t->status &= ~SC_CROP; 
	       aps_fitpsffpbw (t, ins);
	       if ((t->status&(SC_IDENTIFIED|SC_LOCKED)) || t->s0.signif > psig)
		  t->status |= SC_CROP;
	       if (ml) wLog (DBG_CONT, "  >> fit >>  ");
	    }
	    if (ml) wLog (DBG_CONT, (t->status&SC_CROP) ? " OK\n" : " REJECTED\n");
	 }
	 t= t->next;
      }
      ana_weed (sl);
   }
   return sl;
}


void iros_Sllist (char *cmt, WFC_SLLISTPTR sl, cardinal lmt) {
   
   cardinal		Z= 0;  
   WFC_SIMPLESOURCEPTR	T;
   
   T= sl->top;
   while (Z != sl->n && Z != lmt) {
      Z++; 
      printf ("%s: [%2.2d] {%d,%d} flux=%f, err= %f  >>%f %s\n", 
	      (cmt !=+ NULL && *cmt != '\0') ? cmt : "NN", 
	      Z, T->llc.x, T->llc.y, T->s0.flux, T->s0.sigma, T->s0.signif,
	      (T->status&SC_CROP) ? "OK" : "REJ");
      T= T->next;
   }
}

WFC_SLLISTPTR iros_extendsl (WFC_SLLISTPTR new_sl, WFC_SLLISTPTR sl, WFC_IROSPTR irs,
			     WFC_INSTRUMENTPTR ins, float dSumlim, cardinal lpcnt, cardinal epln) 
{
   cardinal	flgs;
   char		mess[256];
   
   dta_section (irs->rsy->sky, 0, 0, ins->cor.sn.x);
   dta_section (irs->rsy->sky, 1, 0, ins->cor.sn.y);
   
   new_sl= ana_search (new_sl, sl, irs, ins->cor.cf, epln, dSumlim, lpcnt > 1);
   if (irs->rsy->smd != 0.0) return sl;
   
   if (!(new_sl == NULL || new_sl->n == 0)) {
      
      if (gbl_debug&DBG_DEVELOP) {
	 sprintf (mess, "iros_extendsl: ana_search gathered %d new candidates (%f .. %f)\n",
		  new_sl->n, new_sl->top->s0.signif, new_sl->top->prev->s0.signif);
	 wLog (DBG_CHAT, mess);
      }
      new_sl->ra = irs->rsy->exp->ra; new_sl->dec= irs->rsy->exp->dec; new_sl->na = irs->rsy->exp->na;
      if (irs->rsy->exp->ctl != NULL) {
	 ana_sigthreshold (new_sl, lpcnt, irs->sdc);
	 ana_identify (new_sl, irs->rsy->exp->ctl, ins, irs->radius);
	 if (irs->irsmode&IRS_AGGRESV) ana_stamp (new_sl);
	 ana_weed (new_sl);
      }
      if (irs->rsy->exp->ctl == NULL && (irs->irsmode&IRS_ANYSHAPE) == 0) {
	 ana_squaretest (new_sl);
	 ana_weed (new_sl);
      }
      
      if (irs->limitsl > 0 && new_sl->n > irs->limitsl)
	 sll_limit (new_sl, irs->limitsl);
      
      flgs= 0; /** PSF_ADJUST **/; 
      if (irs->irsmode&IRS_VOIGTPSF) flgs |= PSF_VOIGT;
      ana_createpsf  (new_sl, 2*irs->psfrsltn+1, ins, flgs);
      
      if (gbl_debug&DBG_DEVELOP) {
	 sprintf (mess, "iros_extendsl: validated %d new sources", new_sl->n);
	 wLog (DBG_CONT, mess);
	 if (new_sl->n > 0) {
	    sprintf (mess, " (%f -- %f)", new_sl->top->s0.signif, new_sl->top->prev->s0.signif);
	    wLog (DBG_CONT, mess);
	 }
	 wLog (DBG_CONT, "\n");
      }
   }
   new_sl= iros_combine (sl, new_sl, irs);
   
   if (lpcnt > 0)
      iros_prune (lpcnt, new_sl, irs, ins);

   return new_sl;
}

void iros_sectionrms (WFC_IROSPTR irs, WFC_INSTRUMENTPTR ins, cardinal dlvl) {
   
#define I_DSSLEN	10

   DATAPTR	d;
   float	*a, rms, r;
   cardinal	ofs[2];
   cardinal	ix, iy;
   char		mess[256];
   cardinal	n= 61, p[I_DSSLEN]= {0, 66, 131, 196, 262, 357, 422, 488, 553, 619};
   
   if (irs->hook == NULL) {
      irs->hook = (void *) C_CALLOC(iros_sectionrms, I_DSSLEN*I_DSSLEN, sizeof (float));
      sprintf (mess, "iros_sectionrms: detector rms per window, initial values.\n");
   }
   else
      sprintf (mess, "iros_sectionrms: detector rms per window, fraction of initial value.\n");
   
   wLog (dlvl, mess);
   if (ins != NULL && ins->sim.det != NULL) {
      if (ins->sim.det != NULL) {
	 wLog (DBG_CONT, "detector.remark:");
	 wLog (DBG_CONT, (ins->sim.det->remark != NULL) ? ins->sim.det->remark : "-");
	 wLog (DBG_CONT, "\n");
      }
      sprintf (mess, "instrument-cal: %s(wfc%d) x[%.2f,%.2f]  y[%.2f,%.2f],  clip[%.2f,%.2f]\n",
	       (ins->cal.calinp != NULL) ? ins->cal.calinp : "<??.no-name>",
	       ins->cal.cam, 
	       ins->cal.xofs.L, ins->cal.xofs.H,
	       ins->cal.yofs.L, ins->cal.yofs.H, 
	       ins->cal.clip.L, ins->cal.clip.H);
      wLog (DBG_CONT, mess);
   }
   
   a= (float *) irs->hook;
   
   d= irs->rsy->exp->di;
   r= (float) n*n;
   for (iy= I_DSSLEN; iy!= 0; iy--) {
      memset ((void *) mess, ' ', 256);
      dta_section (d, 1, p[iy-1], n); ofs[1]= p[iy-1];
      sprintf (mess, "%4d|", p[iy-1]);
      for (ix= 0; ix!= I_DSSLEN; ix++) {	 
	 dta_section (d, 0, p[ix], n); ofs[0]= p[ix]; 
	 
	 rms= sqrt ((double) dta_svv (ODOT, d, d, ofs)/r);
	 if (a[(iy-1)*I_DSSLEN+ix] == 0.0)
	    a[(iy-1)*I_DSSLEN+ix]= rms;
	 else
	    rms= rms/a[(iy-1)*I_DSSLEN+ix];
	 sprintf (mess+5+ix*I_DSSLEN, " %9.3f", rms);
      }
      sprintf (mess+5+I_DSSLEN*I_DSSLEN, "\n");
      wLog (DBG_CONT, mess);
   }
   sprintf (mess, "    |");
   for (ix= 0; ix!= I_DSSLEN; ix++) sprintf (mess+5+ix*I_DSSLEN, " - - - - -");
   mess[5+I_DSSLEN*I_DSSLEN]= '\n'; wLog (DBG_CONT, mess);
   
   sprintf (mess, "    |");
   for (ix= 0; ix!= I_DSSLEN; ix++) sprintf (mess+5+ix*I_DSSLEN, " %4d    ", p[ix]);
   mess[5+I_DSSLEN*I_DSSLEN]= '\n'; wLog (DBG_CONT, mess);
   wLog (DBG_CONT, "\n");
   
   dta_clrsection (d);
}

float iros_progress (cardinal lc,
		     WFC_SLLISTPTR sl, WFC_IROSPTR irs, WFC_INSTRUMENTPTR ins, float idsum, 
		     cardinal dlvl, DATAPTR tci) 
{
   cardinal		sp0[3], sp1[3];
   float		adsum, rms, d_rms, s_rms;
   
   s_rms= 0.0;
   if (tci != NULL) {
      sp0[0]= sp0[1]= 0; sp0[2]= 0;   
      sp1[0]= sp1[1]= 0; sp1[2]= 1;
      /*** dta_vv (ODIV, tci, irs->rsy->sky, sp0, irs->rsy->sky, sp1); ***/
      dta_vv (OCOPY, tci, irs->rsy->sky, sp0);
      s_rms= dta_svv (ODOT, tci, tci, NULL)/((float) ins->cor.sn.x*ins->cor.sn.y);
      if (s_rms > 0.0) s_rms= sqrt ((double) s_rms);  
   }
   d_rms= dta_svv (ODOT, irs->rsy->exp->di, irs->rsy->exp->di, NULL);
   d_rms= (d_rms > 0.0) ? sqrt ((double) (d_rms/((float) dta_getsize (irs->rsy->exp->di)))) : 0.0;
   
   rms= d_rms;
   
   if (lc == 0 || (gbl_debug&DBG_VISIBMASK) >= dlvl) {
      
      cardinal	m;
      bool	bgs;
      char	mess[256], tis[64];
      
      m  =0; bgs= FALSE;
      if (sl != NULL) {
	 
	 WFC_SIMPLESOURCEPTR t= sl->top;
	 do {
	    if ((t->status&SC_BACKGROUND))
	       bgs= 1;
	    else if (t->s0.flux != 0.0)
	       m++;
	    t= t->next;	    
	 } while (t != sl->top);
      }      

      adsum = dta_sv (OADD, irs->rsy->exp->di);
      if (lc == 0)
	 strcpy (tis, "in");
      else if (lc == ~0)
	 strcpy (tis, "lf");
      else
	 sprintf (tis, "%2.2d", lc);
      sprintf (mess,
	       "iros_loop<%s>: detector sum= %10.1f (%5.1f%%).  rms= %e (%2d src%s%s subtracted)\n",
	       tis, adsum, adsum*100/idsum, d_rms,
	       m, (m != 1) ? "'s" : "", bgs ? "+bg" : "");
      wLog (dlvl, mess);
      if (tci != NULL) {
	 sprintf (mess, "                       sky rms= %e (unused)\n", s_rms);
	 wLog (DBG_CONT, mess);
      }
      
      if (ins->cal.inl != NULL)
	 if (lc == 0 || (gbl_debug&DBG_VISIBMASK) > dlvl)
	    iros_sectionrms (irs, ins, dlvl);
      
   }
   if ((gbl_debug&DBGMDL_IRS) && (gbl_debug&DBG_VISIBMASK) >= IRS_GSNDRSPCALL)
      iros_gsnreport (sl, ins, NULL, rms, adsum, adsum*100/idsum);
   
   return rms;
}

WFC_SLLISTPTR iros_loop (WFC_SLLISTPTR	sl_in, WFC_IROSPTR irs,
			 WFC_INSTRUMENTPTR ins, WFC_FILTERPTR fltr, cardinal epln)
{
   WFC_SLLISTPTR	sl;
   WFC_SIMPLESOURCEPTR	ssp;
   WFC_EXPOSEPTR	exp;
   cardinal		i, looplimit, loopcount, sp0[3];
   DATAPTR		error, tdi, di_sim, ci= NULL;
   TILEBOX_PTR		tile= NULL;
   float		idsum, dsumlimit, rms, rmsPrev;
   char			mess[256], name[256];
   bool			soco, Done;
   
   exp= irs->rsy->exp;
   loopcount= 0;
   /***
   **** if irs->niros > 0, it was set from the commandline (default == 0).
   **** obey literally, that is make this many iterations, whatsoever.
   **** set soco, StopOnCountOnly.
   ***/
   soco      = irs->niros > 0;
   looplimit = (irs->niros > 0) ? irs->niros : ITRTNLIMIT;   
   irs->niros= loopcount= 0;
   
   idsum= dta_sv (OADD, exp->di);
   if (idsum <= 0.0) {
      sprintf (mess, "iros_loop: detector sum not +ve (= %f) on entry\n", idsum);
      wLog (DBG_WARNING, mess);
      return sl_in;
   }
   
   error = dta_dupdatarec ("error", ins->cor.mskdft, 2, TRUE);
   sp0[0]= sp0[1]= 0; sp0[2]= 1;   
   dta_vv (OCOPY, error, irs->rsy->sky, sp0);
   /***
   **** special case: IRS_PIXAPPRCH, each skypixel treated
   **** 		   as a source by itself, the parameter thrshd now gives the
   ****		   minimum area (detector) to be illuminated.
   ***/
   dsumlimit= irs->thrshld;
   if (!(irs->irsmode&IRS_PIXAPPRCH)) { 
      if (irs->thrshld <= 0.0) dsumlimit= 0.8;   
      if (exp->time > 0.0) dsumlimit= dsumlimit/exp->time;
      dsumlimit= dsumlimit*idsum;
   }
   
   tdi= dta_dupdatarec ("tdi", exp->di, 2, TRUE);
   dta_vv (OCOPY, tdi, exp->di, NULL);
   
   if ((gbl_debug&DBGMDL_IRS) && (gbl_debug&DBG_VISIBMASK) >= DBG_L3) {
      sprintf (name, "iros_inpdi%d-%d",  exp->bands[epln].L, exp->bands[epln].H);	 
      wft_createimage (name, WFC_TSTID, NULL, tdi);
   }
   
   if ((gbl_debug&DBGMDL_IRS) && (gbl_debug&DBG_VISIBMASK) >= IRS_GSNDRSPCALL) 
     iros_gsnreport (NULL, ins, exp->bands+epln, 0.0, 0.0, 0.0);
   
   rms=  0.0;
   sl = NULL;   di_sim   = NULL;
   ci = NULL;
   if (irs->irsmode&IRS_SHOWSKYRMS) 
      ci= dta_dupdatarec ("ci", irs->rsy->sky, 2, TRUE);
   
   while (TRUE) {
      
      rmsPrev= rms;
      rms= iros_progress (loopcount, sl, irs, ins, idsum, DBG_L2, ci);
      if (sl != NULL && !soco && rms-rmsPrev > 1.0e-6) {
	 ssp= sl->top;
	 for (i= 0; i!= sl->n; i++) {ssp->s0= ssp->s1; ssp= ssp->next;}	 
	 rms= rmsPrev;
      }      
      Done= !(rms > 0.0 && fabs ((double)((rmsPrev-rms)/rms)) > DRMSEPSILON);
      
      /**
      *** loop breaks HERE.
      **/
      if (loopcount == looplimit || (!soco && Done)) break; loopcount++;
      /**	------------------------------------------------	**/
      
      sl= iros_extendsl   (sl_in, sl, irs, ins, dsumlimit, loopcount, epln);      
      sl= iros_background (sl, ins, idsum/irs->rsy->exp->time);
      sl_in= NULL;   
      
      if ((gbl_debug&DBGMDL_IRS) && (gbl_debug&DBG_VISIBMASK) >= DBG_L1)
	 tile= iros_addtile (tile, sl, loopcount-1, looplimit);
      
      dta_vv (OCOPY, exp->di, tdi, NULL);
      di_sim= iros_reduce (di_sim, sl, irs, exp, epln, ins, fltr);
      
      dta_section (irs->rsy->sky, 2, 1, 1);
      dta_vv (OCOPY, irs->rsy->sky, error, NULL);
      dta_section (irs->rsy->sky, 2, 0, 2);
      
      if ((gbl_debug&DBGMDL_IRS) && (gbl_debug&DBG_VISIBMASK) >= DBG_L3) {
	 sprintf (name, "iros_redexp_%2.2d", loopcount);	 
	 wft_createimage (name, WFC_TSTID, NULL, di_sim);
	 sprintf (name, "iros_redsky_%2.2d", loopcount);	 
	 wft_createimage (name, WFC_TSTID, NULL, irs->rsy->sky);
      }      
      ana_weed (sl);  /** SC_NOFIT tagged entries. **/
   }
   
   if ((irs->irsmode&IRS_DETLSQFIT) && !(irs->irsmode&IRS_PIXAPPRCH)) {
      dta_clrsection (exp->di);
      dta_vv (OCOPY, exp->di, tdi, NULL);
      sl= iros_solve (sl, irs, exp, epln, ins, fltr);
      dta_section (irs->rsy->sky, 2, 1, 1);
      dta_vv (OCOPY, irs->rsy->sky, error, NULL);
      dta_section (irs->rsy->sky, 2, 0, 2);
      
      rmsPrev= rms;
      if ((gbl_debug&DBG_VISIBMASK) >= DBG_L2)
	 src_showsl ("iros_loop: subtracted", sl, ins->focallength, NULL, 3, DBG_L2);
      rms= iros_progress ((cardinal) ~0, sl, irs, ins, idsum, DBG_L1, ci);
   }
   if (sl != NULL && (irs->irsmode&IRS_PIXAPPRCH)) iros_position (sl);
   
   dta_section (irs->rsy->sky, 0, 0, ins->cor.sn.x);
   dta_section (irs->rsy->sky, 1, 0, ins->cor.sn.y);
   dta_section (irs->rsy->sky, 2, 0, 2);
   
   
   if (tile != NULL) {
      dta_clrsection (tile->tile);
      sprintf (mess, "iros-tile.pln%d", epln);
      wft_createimage (mess, WFC_TSTID, NULL, tile->tile);
      dta_destroy (tile->tile);
      free (tile);
   }   
   irs->niros= loopcount;
   
   if (ci != NULL) dta_destroy (ci);
   return sl;
}
