/** $Header$
********************************** - - ****************************************
* 						   
*         _/_/_/_/_/_/    _/_/_/    _/_/      _/_/       SRON Utrecht
*      _/_/_/_/  _/_/  _/_/_/_/_/  _/_/_/  _/_/_/    
*     _/_/_/        _/_/      _/_/  _/_/_/_/_/       _/     _/ _/_/_/_/ _/_/_/
*      _/_/_/_/_/  _/_/_/_/_/_/_/    _/_/_/         _/     _/ _/     _/_/
*           _/_/_/_/_/_/_/_/_/_/  _/_/_/_/_/  _/_/ _/  _/ _/ _/_/_/ _/      
*  _/_/  _/_/_/_/_/_/      _/_/_/_/_/  _/_/_/     _/_/ _/_/ _/     _/_/  
* _/_/_/_/_/_/  _/_/      _/_/_/_/      _/_/     _/     _/ _/       _/_/_/   
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* Use	      :	jz_shiftPointing ();
*
* Parameters  :	
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* Dependencies:	
*
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* Description :	 Transform from raw attitude to WFC pointing, by jean.
*		 repair northangle at high(low) attitudes.
*  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
* $Log$
*/


#include <stdlib.h>
#include <math.h>
#include "wfcglobals.h"

void jz_shiftPointing (rpair d, float dr, double *rar, double *der, double *nar) {
   double	ra, de, de2, na;
   float	xr, yr, xl0, yl0, xl1, yl1;	
   
   ra= *rar;
   de= *der;
   na= *nar+dr; while (na < 0.0) na+= 360.0; while (na > 360.0) na-= 360.0;
   
   set_trafomatrix_imce (&ra, &de, &na); 
   trafo_imce(&d.x, &d.y, &ra, &de);

   set_trafomatrix_ceim (rar, der, &na); 
   trafo_ceim(&ra, &de, &xl0, &yl0, 0.0);
   
   de2 = de+0.1;
   trafo_ceim(&ra, &de2, &xl1, &yl1, 0.0);
   
   na = WFC_RAD2DEG(atan2((yl1-yl0), (xl1-xl0))); if (na < 0.0) na+= 360.0;

   *rar= ra;   *der= de;   *nar= na;
}	

